#ifdef GL_ES
precision mediump float;

varying vec3 normal;
vec4 fragColor;
#else
in vec3 normal;
out vec4 fragColor;
#endif
uniform vec4 inColor;
uniform vec3 specularColor;

uniform vec3 lightSource4;
uniform vec3 lightSource4HV;

void main()
{
    vec3 norm = normalize(normal);
    float lambert = dot(norm, lightSource4);
    vec3 specular = (pow(dot(norm, lightSource4HV), 8.0) * 0.35) * specularColor;
    vec3 diffuse = inColor.rgb * (lambert * 0.75 * 0.75);

    fragColor = vec4(diffuse + specular, inColor.a);
#ifdef GL_ES
    gl_FragColor = fragColor;
#endif
}
